<?php
namespace Import\ApiBundle\Services\Import;

use Import\ApiBundle\Services\Api\ApiMainService;

class ImportMainService extends ApiMainService
{
    protected function getCSVFromZip($urlZip,$type,$columns = null)
    {
        $filePath = $this->getZipFile($urlZip,$type);
        return $this->getCSV($filePath,$columns);
    }

    protected function getCSV($url,$columns = null,$delimiter = ",")
    {
        $rows = array();
        if(!file_exists($url))
        {
            echo "\n\r".'FILE NOT EXIST: '.$url."\n\r";
            return array();
        }
        if (($handle = fopen($url, "r", 1)) !== FALSE)
        {
            while (($data = fgetcsv($handle, null, $delimiter,'"')) !== FALSE)
            {
                if($columns)
                {
                    $data = $this->prepareRow($data,$columns);
                }
                $rows[] = $data;
            }
            fclose($handle);
        }
        return $rows;
    }

    protected function getZipFile($urlZip,$type)
    {
        $date = new \DateTime();
        $urlDest = __DIR__."/../../../../../web/files";
        if(!is_dir($urlDest))
        {
            mkdir($urlDest, 0777);
        }
        $urlDest .= "/".$type;
        if(!is_dir($urlDest))
        {
            mkdir($urlDest, 0777);
        }
        $urlDest .= "/".$date->format('YmdHis');
        $zipName = 'few_last.zip';
        $fileName = $date->modify('-1 day')->format('Ymd').'.prn';
        if(!is_dir($urlDest))
        {
            mkdir($urlDest, 0777);
        }

        file_put_contents($urlDest.'/'.$zipName, fopen($urlZip, 'r'));

        $zip = new \ZipArchive();
        if ($zip->open($urlDest.'/'.$zipName) === TRUE)
        {
            $zip->extractTo($urlDest,array($fileName));
            $zip->close();
        }

        return $urlDest.'/'.$fileName;
    }

    protected function prepareRow($row, $columns)
    {
        $newRow = array();
        foreach($row as $id => $el)
        {
            $newRow[$columns[$id]] = $el;
        }
        return $newRow;
    }

    protected function getTableFromPage($url,$columns)
    {
        $headRow = true;
        $content=file_get_contents($url);
        $content = str_replace('<opis>','',$content);
        $content = str_replace('</opis>','',$content);

        $DOM = new \DOMDocument;
        $DOM->loadHTML($content);

        $trs = $DOM->getElementsByTagName('tr');

        $res = array();
        foreach ($trs as $tr)
        {
            $tds = $tr->getElementsByTagName('td');
            if(!$headRow)
            {
                $res[] = array(
                    $columns[0] => trim($tds->item(0)->nodeValue),
                    $columns[1] => trim($tds->item(1)->nodeValue)
                );
            }
            else
            {
                $headRow = false;
            }
        }
        return $res;
    }

    protected function getTableWithoutHeaderFromPage($url,$columns)
    {
        $content=file_get_contents($url);
        $content = str_replace('<opis>','',$content);
        $content = str_replace('</opis>','',$content);

        $DOM = new \DOMDocument;
        $DOM->loadHTML($content);
        $trescTag = $DOM->getElementById('tresc');
        $table = $trescTag->getElementsByTagName('table')->item(0);
        $trs = $table->getElementsByTagName('tr');
        $res = array();
        foreach ($trs as $tr)
        {
            $tds = $tr->getElementsByTagName('td');
            $res[] = array(
                $columns[0] => trim($tds->item(0)->nodeValue),
                $columns[1] => trim($tds->item(1)->nodeValue)
            );
        }
        return $res;
    }

    protected function getIncomeTaxTableAndYearFromPage($url,$columns)
    {
        $headRows = 2;
        $currentRow = 1;
        $content=file_get_contents($url);
        $content = str_replace('<opis>','',$content);
        $content = str_replace('</opis>','',$content);

        $DOM = new \DOMDocument;
        $DOM->loadHTML($content);

        $trescTag = $DOM->getElementById('tresc');
        $opis = trim($trescTag->getElementsByTagName('p')->item(0)->nodeValue);
        $opis = explode(' ', $opis);
        $year = 0;
        foreach($opis as $value)
        {
            if(is_numeric($value))
            {
                $value *= 1;
                if(is_int($value))
                {
                    if($value > 2000 && $value < 2050)
                    {
                        $year = $value;
                    }
                }
            }
        }

        $trs = $trescTag->getElementsByTagName('tr');

        $res = array();
        foreach ($trs as $tr)
        {
            $tds = $tr->getElementsByTagName('td');
            if(!($currentRow <= $headRows))
            {
                $res[] = array(
                    $columns[0] => trim($tds->item(0)->nodeValue),
                    $columns[1] => trim($tds->item(1)->nodeValue),
                    $columns[2] => trim($tds->item(2)->nodeValue)
                );
            }
            $currentRow++;
        }

        $out = new \stdClass();
        $out->res = $res;
        $out->year = $year;

        return $out;
    }

    protected function getPaymentMinFromPage($url)
    {
        $content=file_get_contents($url);
        $content = str_replace('<opis>','',$content);
        $content = str_replace('</opis>','',$content);

        $DOM = new \DOMDocument;
        $DOM->loadHTML($content);

        $bs = $DOM->getElementsByTagName('strong');

        $res = array();
        foreach ($bs as $b)
        {
            if(strpos($b->nodeValue,'Minimalne wynagrodzenie za pracę') !== false)
            {
                $value = $b->nodeValue;
                $value = str_replace('Minimalne wynagrodzenie za pracę wynosi od','',$value);
                $value = str_replace('r.','',$value);
                $value = str_replace(' - ','',$value);
                $value = str_replace('zł','',$value);
                $value = trim($value);

                $valueArray = explode(' ',$value);
                $DataTime = $this->createDataFromArray($valueArray);
                if(!$DataTime)
                {
                    $this->addError(3,$b->nodeValue,$this->type);
                    return false;
                }
                $valueArray[3] = str_replace('.','',$valueArray[3]);
                $valueArray[3] = str_replace(',','',$valueArray[3]);

                $res['DataFrom'] = $DataTime;
                $res['Value'] = $valueArray[3];
            }
        }
        return $res;
    }

    protected function getPaymentAvgFromPage($url)
    {
        $DOM = $this->getDOMDocument($url);

        $tags = $DOM->getElementsByTagName('tr');

        foreach ($tags as $tag)
        {
            foreach ($tag->getElementsByTagName('tr') as $tag1)
            {
                foreach ($tag1->getElementsByTagName('tr') as $tag2)
                {
                    if(strpos($tag2->nodeValue,'zł') !== false)
                    {
                        $value = $tag2->nodeValue;
                        $value = str_replace('zł','',$value);
                        $value = trim($value);
                        $value = str_replace('.','',$value);
                        $value = str_replace(',','.',$value);
                        $value = (float)$value;

                        if($value > 1500)
                        {
                            return $value;
                        }
                    }
                }

            }
        }
        return false;
    }

    protected function getContributionZUSFromPage($url)
    {
        $DOM = $this->getDOMDocument($url);
        $tags = $DOM->getElementsByTagName('tr');

        $ContributionZUS = array(
            'employee' => array('emerytalne' => null,'rentowe' => null,'chorobowe'  => null,'wypadkowe'	 => null,'zdrowotne' => null),
            'employer' => array('emerytalne' => null,'rentowe' => null),
        );
        foreach ($tags as $tag)
        {
            foreach ($tag->getElementsByTagName('tr') as $tag1)
            {
                $el = $tag1->getElementsByTagName('td');
                switch ($el->item(0)->nodeValue) {
                    case 'emerytalne' :
                        $ContributionZUS['employer']['emerytalne'] = $el->item(1)->nodeValue;
                        $ContributionZUS['employee']['emerytalne'] = $el->item(2)->nodeValue;
                        break;
                    case 'rentowe' :
                        $ContributionZUS['employer']['rentowe'] = $el->item(1)->nodeValue;
                        $ContributionZUS['employee']['rentowe'] = $el->item(2)->nodeValue;
                        break;
                    case 'chorobowe' :
                        $ContributionZUS['employee']['chorobowe'] = $el->item(2)->nodeValue;
                        break;
                    case 'wypadkowe' :
//                        $ContributionZUS['employer']['wypadkowe'] = $el->item(1)->nodeValue;
//                        $ContributionZUS['employee']['wypadkowe'] = $el->item(2)->nodeValue;
                        break;
                    case 'zdrowotne' :
                        $ContributionZUS['employee']['zdrowotne'] = $el->item(2)->nodeValue;
                        break;
                }
            }
        }

        foreach($ContributionZUS as $employ => $Contributions)
        {
            foreach ($Contributions as $name => $value)
            {
                $value = str_replace('%','',$value);
                $value = str_replace(',','.',$value);
                $value = trim($value);
                $ContributionZUS[$employ][$name] = $value;
            }
        }

        return $ContributionZUS;
    }

    protected function getInterestRateFPAndFGSPFromPage($url)
    {
        $DOM = $this->getDOMDocument($url);
        $xpath = new \DOMXpath($DOM);

        $InterestRateFPAndFGSP = array('FP' => null,'FGSP' => null);
        $InterestRateName = array('FP','FGSP');

        $tables = $xpath->evaluate('/html/body/div/table/tr/td/table/tr/td/div/div/div/table');
        foreach($tables as $id => $table)
        {
            $td = $table->getElementsByTagName('tr')->item(1)->getElementsByTagName('td')->item(1);
            $td = $td->nodeValue;
            $td = str_replace(',','.',$td);
            $td = trim($td);
            $InterestRateFPAndFGSP[$InterestRateName[$id]] = $td;
        }

        return $InterestRateFPAndFGSP;
    }

    protected function getWiborFromPage($url)
    {
        $DOM = $this->getDOMDocument($url);

        $nameParam = 'aktualna wartość';
        $wibor = 0;
        $tds = $DOM->getElementById('notowania_d')->getElementsByTagName('td');

        foreach($tds as $index => $td)
        {
            if(strpos($nameParam,$td->nodeValue) !== false)
            {
                $wibor = str_replace(',','.',$tds->item($index+1)->nodeValue);
            }
        }

        return $wibor;
    }

    protected function getLinksFromPage($url,$titleSearch)
    {
        $DOM = $this->getDOMDocument($url);
        $tags = $DOM->getElementsByTagName('a');

        $titleSearch = strtolower($titleSearch);
        $links = array();
        foreach ($tags as $tag)
        {
            $title = trim($tag->getattribute('title'));
            $title = str_replace("\r\n", "", str_replace("\n", "", str_replace("\r", "", $title)));

            if(!empty($title) && (strpos($title,$titleSearch.' okres') !== false))
            {
                $dates = str_replace($titleSearch.' okres od ','',$title);
                $dates = str_replace(' do ','',$dates);
                $dateseArray = explode(' ',$dates);

                $dataFrom = explode('-',$dateseArray[0]);
                $year = (int)$dataFrom[0];
                $month = (int)$dataFrom[1];

                $yearTo = 0;
                $monthTo = 0;
                if(isset($dateseArray[1]))
                {
                    $dataTo = explode('-',$dateseArray[1]);
                    $yearTo = (int)$dataTo[0];
                    $monthTo = (int)$dataTo[1];
                }

                if(!isset($links[$month.'_'.$year.'_'.$monthTo.'_'.$yearTo]))
                {
                    $links[$month.'_'.$year.'_'.$monthTo.'_'.$yearTo] = array(
                        'description' => $title,
                        'year' => $year,
                        'month' => $month,
                        'yearTo' => $yearTo,
                        'monthTo' => $monthTo,
                        'href' => 'http://www.wskazniki.gofin.pl/'.$tag->getattribute('href')
                    );
                }
            }
        }

        return $links;
    }

    /**
     * @param $dataArray
     * @return bool|\DateTime
     */
    protected function createDataFromArray($dataArray)
    {
        $day = $dataArray[0];
        $year = $dataArray[2];
        switch ($dataArray[1]) {
            case 'stycznia' : $month = 1; break;
            case 'lutego' : $month = 2; break;
            case 'marca' : $month = 3; break;
            case 'kwietnia' : $month = 4; break;
            case 'maja' : $month = 5; break;
            case 'czerwca' : $month = 6; break;
            case 'lipca' : $month = 7; break;
            case 'sierpnia' : $month = 8; break;
            case 'września' : case 'wrzenia' : $month = 9; break;
            case 'października' : $month = 10; break;
            case 'listopada' : case 'listopad' : $month = 11; break;
            case 'grudnia' : $month = 12; break;
            default : $month = 0; break;
        }
        if($month < 1)
        {
            return false;
        }
        return new \DateTime($day.'-'.$month.'-'.$year);
    }

    protected function getValueForTableInDiv($div)
    {
        $div->getElementsByTagName('p');
    }

    protected function getDOMDocument($url)
    {
        $content=file_get_contents($url);
        $content = strtolower($content);

        $content = str_replace('&','&amp;"',$content);
        $content = str_replace('&amp;"#8211; gofin.pl','',$content);
        $content = str_replace('&amp;"bull;','',$content);
        $content = str_replace('</br>','',$content);
        $content = str_replace('</div></a>','</div>',$content);
        $content = preg_replace('/\$\("body"\)\.prepend\((.*)"\);/','',$content);

        $content = str_replace('<center>','',$content);
        $content = str_replace('</center>','',$content);

        libxml_use_internal_errors(true);

        $DOM = new \DOMDocument;
        $DOM->loadHTML($content);

        return $DOM;
    }
}
